<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:param name="Local">local</xsl:param>
<xsl:param name="ImgPath">../js</xsl:param>
<xsl:param name="lang">en</xsl:param>
<xsl:param name="ExistDoc">0</xsl:param>
<xsl:template match="/">
<!-- Build = 2006.03.22 -->
<html>
<div id="header">
<!--
	<img align='absmiddle' class="logo">
		<xsl:attribute name="src">
			<xsl:if test="$lang != 'ja'">
				<xsl:value-of select="$ImgPath" />/logo_en.gif
			</xsl:if>
			<xsl:if test="$lang = 'ja'">
				<xsl:value-of select="$ImgPath" />/logo_jp.gif
			</xsl:if>
		</xsl:attribute>
	</img>
-->
	<div class="mno">
		No.<xsl:value-of select="//MNO"/>
	</div>
	<select class="mnames" size="3">
		<xsl:call-template name="sepmnames">
			<xsl:with-param name="mnames"><xsl:value-of select="//MNAME"/></xsl:with-param>
		</xsl:call-template>
	</select>
	<div class="setup">
		<input type="button" name="btn0">
			<xsl:attribute name="value">
				<xsl:if test="$lang != 'ja'">OPEN DOC</xsl:if>
				<xsl:if test="$lang = 'ja'">本文を開く</xsl:if>
			</xsl:attribute>
			<xsl:attribute name="onclick">
				openDocument();
			</xsl:attribute>
			<xsl:if test="$ExistDoc = '0'">
				<xsl:attribute name="disabled">
					true
				</xsl:attribute>
			</xsl:if>
		</input>
		<input type="button" name="btn1" onclick="mysetup()">
			<xsl:attribute name="value">
				<xsl:if test="$lang != 'ja'">SETUP</xsl:if>
				<xsl:if test="$lang = 'ja'">環境設定</xsl:if>
			</xsl:attribute>
		</input>
<!--
		<input type="button" name="btn1">
			<xsl:attribute name="value">
				<xsl:if test="$lang != 'ja'">HELP</xsl:if>
				<xsl:if test="$lang = 'ja'">ヘルプ</xsl:if>
			</xsl:attribute>
			<xsl:attribute name="onclick">
				<xsl:if test="$lang != 'ja'">openNewWindow("../../xmlhelp/help_en.html", "scrollbars=yes,resizable=yes,menubar=yes,directories=no,status=no,location=no,width=800,height=600")</xsl:if>
				<xsl:if test="$lang = 'ja'">openNewWindow("../../xmlhelp/help_ja.html", "scrollbars=yes,resizable=yes,menubar=yes,directories=no,status=no,location=no,width=800,height=600")</xsl:if>
			</xsl:attribute>
		</input>
-->
		<br/>
		<input type="checkbox" name="l1" onclick="chgtpl(this)" />
		<xsl:if test="$lang != 'ja'">FIG.SCH/FIG.PCB: SIMULTANEOUS</xsl:if>
		<xsl:if test="$lang = 'ja'">回路図/基板図：同時表示</xsl:if>
	</div>
	<br/>
</div>
</html>
</xsl:template>

<xsl:template name="sepmnames">
	<xsl:param name="mnames" select="."/>
	<xsl:value-of select="substring-before($mnames, ',')"/>
	<xsl:if test="substring-before($mnames, ',') != ''">
		<option>
			<xsl:value-of select="substring-before($mnames, ',')"/>
		</option>
	</xsl:if>
	<xsl:choose>
		<xsl:when test="contains($mnames, ',')">
			<xsl:call-template name="sepmnames">
				<xsl:with-param name="mnames" select="substring-after($mnames, ',')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="string-length($mnames) &gt; 0">
			<option>
				<xsl:value-of select="$mnames"/>
			</option>
		</xsl:when>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>
